<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});



// Published pages are now handled by React frontend

// Catch-all route for React SPA - must be last
Route::get('/{any}', function () {
    return view('welcome');
})->where('any', '.*');

// Serve media files with CORS headers
Route::get('/media/{filename}', function ($filename) {
    $path = public_path('media/' . $filename);
    if (!file_exists($path)) {
        abort(404);
    }

    $mimeType = mime_content_type($path) ?: 'application/octet-stream';
    return response()->file($path)
        ->header('Content-Type', $mimeType)
        ->header('Access-Control-Allow-Origin', '*')
        ->header('Access-Control-Allow-Methods', 'GET, OPTIONS')
        ->header('Access-Control-Allow-Headers', 'Content-Type');
})->where('filename', '.*');


