<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('is_affiliate')->default(false)->after('is_admin');
            $table->string('affiliate_code')->unique()->nullable()->after('is_affiliate');
            $table->integer('affiliate_balance')->default(0)->after('affiliate_code');
            $table->integer('total_referred')->default(0)->after('affiliate_balance');
            $table->foreignId('referrer_id')->nullable()->constrained('users')->onDelete('set null')->after('total_referred');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['referrer_id', 'total_referred', 'affiliate_balance', 'affiliate_code', 'is_affiliate']);
        });
    }
};
