<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pos_sales', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('pos_customer_id')->constrained('pos_customers')->onDelete('cascade');
            $table->foreignId('pos_product_id')->constrained('pos_products')->onDelete('cascade');
            $table->foreignId('pos_channel_id')->constrained('pos_channels')->onDelete('cascade');
            $table->foreignId('pos_payment_id')->constrained('pos_payments')->onDelete('cascade');
            $table->foreignId('pos_admin_id')->constrained('pos_admins')->onDelete('cascade');
            $table->decimal('price', 15, 2);
            $table->string('link')->nullable();
            $table->date('date');
            $table->date('ship_date')->nullable();
            $table->text('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pos_sales');
    }
};
