<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\CrmCard;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update existing CRM cards with status 'ToDo' to 'To Contact'
        CrmCard::where('status', 'ToDo')->update(['status' => 'To Contact']);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Reverse the update
        CrmCard::where('status', 'To Contact')->update(['status' => 'ToDo']);
    }
};
