<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;
use App\Models\AffiliateWithdraw;
use App\Models\Setting;
use App\Models\Page;
use App\Models\Product;
use App\Models\Customer;
use App\Models\Order;
use App\Models\CrmCard;
use App\Models\Media;
use App\Models\Subscription;
use App\Models\Payment;
use App\Models\PosCustomer;
use App\Models\PosProduct;
use App\Models\PosChannel;
use App\Models\PosPayment;
use App\Models\PosAdmin;
use App\Models\PosSale;

class User extends Authenticatable implements JWTSubject
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'is_admin',
        'is_affiliate',
        'affiliate_code',
        'affiliate_balance',
        'total_referred',
        'referrer_id',
        'email_changed_at',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'is_admin' => 'boolean',
            'is_affiliate' => 'boolean',
            'affiliate_balance' => 'integer',
            'total_referred' => 'integer',
            'email_changed_at' => 'datetime',
        ];
    }

    // Relationships
    public function settings()
    {
        return $this->hasOne(Setting::class);
    }

    public function pages()
    {
        return $this->hasMany(Page::class);
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function customers()
    {
        return $this->hasMany(Customer::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function crmCards()
    {
        return $this->hasMany(CrmCard::class);
    }

    public function media()
    {
        return $this->hasMany(Media::class);
    }

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    // Affiliate relationships
    public function affiliateWithdraws()
    {
        return $this->hasMany(AffiliateWithdraw::class);
    }

    public function referrer()
    {
        return $this->belongsTo(User::class, 'referrer_id');
    }

    public function referredUsers()
    {
        return $this->hasMany(User::class, 'referrer_id');
    }

    // POS relationships
    public function posCustomers()
    {
        return $this->hasMany(PosCustomer::class);
    }

    public function posProducts()
    {
        return $this->hasMany(PosProduct::class);
    }

    public function posChannels()
    {
        return $this->hasMany(PosChannel::class);
    }

    public function posPayments()
    {
        return $this->hasMany(PosPayment::class);
    }

    public function posAdmins()
    {
        return $this->hasMany(PosAdmin::class);
    }

    public function posSales()
    {
        return $this->hasMany(PosSale::class);
    }

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->id;
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
}
