<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosSale extends Model
{
    use HasFactory;

    protected $table = 'pos_sales';

    protected $fillable = [
        'user_id',
        'pos_customer_id',
        'pos_product_id',
        'pos_channel_id',
        'pos_payment_id',
        'pos_admin_id',
        'price',
        'link',
        'date',
        'ship_date',
        'note',
        'referral_code',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'date' => 'date',
        'ship_date' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function customer()
    {
        return $this->belongsTo(PosCustomer::class, 'pos_customer_id')->select('id', 'name', 'username', 'note');
    }

    public function product()
    {
        return $this->belongsTo(PosProduct::class, 'pos_product_id')->select('id', 'name', 'type', 'sku');
    }

    public function channel()
    {
        return $this->belongsTo(PosChannel::class, 'pos_channel_id')->select('id', 'name', 'desc', 'url');
    }

    public function payment()
    {
        return $this->belongsTo(PosPayment::class, 'pos_payment_id')->select('id', 'name', 'desc', 'code');
    }

    public function admin()
    {
        return $this->belongsTo(PosAdmin::class, 'pos_admin_id')->select('id', 'name', 'username', 'note');
    }
}
