<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosProduct extends Model
{
    use HasFactory;

    protected $table = 'pos_products';

    protected $fillable = [
        'user_id',
        'name',
        'type',
        'sku'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function posSales()
    {
        return $this->hasMany(PosSale::class);
    }
}
