<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosPayment extends Model
{
    use HasFactory;

    protected $table = 'pos_payments';

    protected $fillable = [
        'user_id',
        'name',
        'desc',
        'code',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function posSales()
    {
        return $this->hasMany(PosSale::class);
    }
}
