<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosCustomer extends Model
{
    use HasFactory;

    protected $table = 'pos_customers';

    protected $fillable = [
        'user_id',
        'name',
        'username',
        'note'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function posSales()
    {
        return $this->hasMany(PosSale::class);
    }
}
