<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CrmCard extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'customer_id',
        'status',
        'value',
    ];

    protected $casts = [
        'value' => 'decimal:2',
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
