<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Block extends Model
{
    use HasFactory;

    protected $fillable = [
        'page_id',
        'type',
        'props',
        'order',
    ];

    protected $casts = [
        'props' => 'array',
        'order' => 'integer',
    ];

    // Relationships
    public function page()
    {
        return $this->belongsTo(Page::class);
    }
}
