<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AffiliateWithdraw extends Model
{
    protected $fillable = [
        'user_id',
        'amount',
        'account_name',
        'account_number',
        'bank_name',
        'status',
    ];

    protected $casts = [
        'amount' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
