<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AffiliateSetting extends Model
{
    protected $fillable = [
        'commission_percentage',
        'discount_percentage',
    ];

    protected $casts = [
        'commission_percentage' => 'float',
        'discount_percentage' => 'float',
    ];

    /**
     * Get the current affiliate settings (assuming single row)
     */
    public static function getSettings()
    {
        return self::firstOrCreate([], [
            'commission_percentage' => 10.00,
            'discount_percentage' => 5.00,
        ]);
    }
}
