<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $settings = $request->user()->settings ?? $request->user()->settings()->create([
            'currency' => 'USD',
            'language' => 'EN',
        ]);

        return response()->json($settings);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $request->validate([
            'logo_url' => 'nullable|url',
            'favicon_url' => 'nullable|url',
            'currency' => 'required|in:USD,IDR',
            'language' => 'required|in:EN,ID',
        ]);

        $settings = $request->user()->settings ?? $request->user()->settings()->create([
            'currency' => 'USD',
            'language' => 'EN',
        ]);

        $settings->update($request->only([
            'logo_url', 'favicon_url', 'currency', 'language'
        ]));

        return response()->json($settings);
    }
}
