<?php

namespace App\Http\Controllers;

use App\Models\PosAdmin;
use Illuminate\Http\Request;

class PosAdminController extends Controller
{
    public function index()
    {
        $userId = request()->query('user_id');
        if (!$userId) {
            return response()->json(['message' => 'User ID required'], 400);
        }

        return response()->json(PosAdmin::where('user_id', $userId)->get());
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'username' => 'nullable|string|max:255',
            'note' => 'nullable|string',
            'user_id' => 'required|integer',
        ]);

        $posAdmin = PosAdmin::create($validated);

        return response()->json($posAdmin, 201);
    }

    public function show($id)
    {
        $posAdmin = PosAdmin::with('posSales')->findOrFail($id);

        return response()->json($posAdmin);
    }

    public function update(Request $request, $id)
    {
        $posAdmin = PosAdmin::findOrFail($id);

        $validated = $request->validate([
            'name' => 'sometimes|required|string|max:255',
            'username' => 'nullable|string|max:255',
            'note' => 'nullable|string',
        ]);

        $posAdmin->update($validated);

        return response()->json($posAdmin);
    }

    public function destroy($id)
    {
        $posAdmin = PosAdmin::findOrFail($id);
        $posAdmin->delete();

        return response()->json(null, 204);
    }
}
