<?php

namespace App\Http\Controllers;

use App\Models\CrmCard;
use Illuminate\Http\Request;

class CrmCardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $crmCards = CrmCard::where('user_id', auth()->id())
            ->with('customer')
            ->get()
            ->map(function ($card) {
                return [
                    'id' => $card->id,
                    'customerId' => $card->customer_id,
                    'customerName' => $card->customer ? $card->customer->name : 'Unknown Customer',
                    'status' => $card->status,
                    'value' => $card->value,
                ];
            });

        return response()->json($crmCards);
    }

    /**
     * Update the status of a CRM card.
     */
    public function updateStatus(Request $request, string $id)
    {
        $request->validate([
            'status' => 'required|in:To Contact,In Progress,Won,Lost',
        ]);

        $crmCard = CrmCard::where('user_id', auth()->id())
            ->where('id', $id)
            ->firstOrFail();

        $crmCard->update([
            'status' => $request->status,
        ]);

        $crmCard->load('customer');

        return response()->json($crmCard);
    }
}
